import { jsx, jsxs } from "react/jsx-runtime";
import { useEditor, useValue } from "@tldraw/editor";
import { memo } from "react";
import { PORTRAIT_BREAKPOINT } from "../../constants.mjs";
import { useBreakpoint } from "../../context/breakpoints.mjs";
import { useTldrawUiComponents } from "../../context/components.mjs";
import { useReadonly } from "../../hooks/useReadonly.mjs";
import { MobileStylePanel } from "../MobileStylePanel.mjs";
import { DefaultToolbarContent } from "./DefaultToolbarContent.mjs";
import { OverflowingToolbar } from "./OverflowingToolbar.mjs";
import { ToggleToolLockedButton } from "./ToggleToolLockedButton.mjs";
const DefaultToolbar = memo(function DefaultToolbar2({ children }) {
  const editor = useEditor();
  const breakpoint = useBreakpoint();
  const isReadonlyMode = useReadonly();
  const activeToolId = useValue("current tool id", () => editor.getCurrentToolId(), [editor]);
  const { ActionsMenu, QuickActions } = useTldrawUiComponents();
  return /* @__PURE__ */ jsx("div", { className: "tlui-toolbar", children: /* @__PURE__ */ jsxs("div", { className: "tlui-toolbar__inner", children: [
    /* @__PURE__ */ jsxs("div", { className: "tlui-toolbar__left", children: [
      !isReadonlyMode && /* @__PURE__ */ jsxs("div", { className: "tlui-toolbar__extras", children: [
        breakpoint < PORTRAIT_BREAKPOINT.TABLET && /* @__PURE__ */ jsxs("div", { className: "tlui-toolbar__extras__controls tlui-buttons__horizontal", children: [
          QuickActions && /* @__PURE__ */ jsx(QuickActions, {}),
          ActionsMenu && /* @__PURE__ */ jsx(ActionsMenu, {})
        ] }),
        /* @__PURE__ */ jsx(ToggleToolLockedButton, { activeToolId })
      ] }),
      /* @__PURE__ */ jsx(OverflowingToolbar, { children: children ?? /* @__PURE__ */ jsx(DefaultToolbarContent, {}) })
    ] }),
    breakpoint < PORTRAIT_BREAKPOINT.TABLET_SM && !isReadonlyMode && /* @__PURE__ */ jsx("div", { className: "tlui-toolbar__tools", children: /* @__PURE__ */ jsx(MobileStylePanel, {}) })
  ] }) });
});
export {
  DefaultToolbar
};
//# sourceMappingURL=DefaultToolbar.mjs.map
